<title>Top Refer - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://akotamicrojobs.net/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://akotamicrojobs.net/resources/css/myapp.css" type="text/css">
<style>
    .table th {
        background-color: rgba(250, 250, 250, 1); /* White faded background */
        color: #000066; /* Black font color */
        font-size: 12px;
    }
/* Remove vertical borders for table cells and adjust horizontal border color */
    .table-no-vertical-border th,
    .table-no-vertical-border td {
        border-left: none;  /* Remove left border */
        border-right: none; /* Remove right border */
        border-color: rgba(0, 0, 0, 0.1); /* Adjust the border color (0.1 for a very faint line) */
    }
    .table td {
        font-size: 14px;
        color: #000;
    }
    
    .countdown {
            text-transform: uppercase;
            font-weight: bold;
        }
        
        .countdown span {
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1);
            font-size: 3rem;
            margin-left: 0.8rem;
        }
        
        .countdown span:first-of-type {
            margin-left: 0;
        }
        
        .countdown-circles {
            text-transform: uppercase;
            font-weight: bold;
        }
        
        .countdown-circles span {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .countdown-circles span:first-of-type {
            margin-left: 0;
        }
        
        .bg-gradient-4 {
            /*background: #007991;*/
            /*background: -webkit-linear-gradient(to right, #007991, #78ffd6);*/
            /*background: linear-gradient(to right, #007991, #78ffd6);*/
            padding: 5px;
        }
        
        .rounded {
            border-radius: 1rem !important;
        }
        
        .btn-demo {
            padding: 0.5rem 2rem !important;
            border-radius: 30rem !important;
            background: rgba(255, 255, 255, 0.3);
            text-transform: uppercase;
            font-weight: bold !important;
        }
        
        .btn-demo:hover, .btn-demo:focus {
            background: rgba(255, 255, 255, 0.5);
        }
        
        .l-date{
            background-color: green !important;
            color: #fff;
            padding: 0px 13px;
            border-radius: 10px;
            margin-left: 2px !important;
        }
        .l-date-text{
            color: #000;
            font-size: 15px !important;
            line-height: 10px !important;
            margin-left: 2px !important;
        }
        
        @media screen and (max-width: 767px) {
            .l-date{
                font-size: 35px !important;
                padding: 0px 6px;
                border-radius: 5px;
            }
            
            .l-date-text{
                font-size: 10px !important;
            }
        }
</style>
@endsection
@section('user-content')
<div class="card mt-2">
    <div class="card-header">
        <div class="card-title text-center" style="font-weight: 500; color: #2ECC71; font-size: 22px;">Top 10 Refer</div>
    </div>
    <div class="card-body">
    @if ($headlines->isEmpty())   
          
    @else    
        <div class="notice-box mb-2">
            <marquee bgcolor="#000080" style="color:white;padding: 5px;border-radius: 5px;margin-top: 5px" behavior="scroll">
                @foreach ($headlines as $key=>$headline)
                    <a href="{{ $headline->link }}" class="text-white" style="font-size:15px;">
                        <i class="fe fe-link me-2 white-text" aria-hidden="true"></i>{{ $headline->title }}
                    </a>
                    @if (!$loop->last)
                        <span class="mx-2">|</span>
                    @endif
                @endforeach
            </marquee>
        </div>
    @endif
    
        <div class="table-responsive active">
        @if ($top_users->isEmpty())   
           <div class="text-center py-3">
               <p>No Record</p>
           </div>
        @else
            <table class="table table-bordered text-nowrap table-no-vertical-border table-flush" id="example1">
                <thead class="thead-light">
                    <tr>
                        <th scope="col border-bottom-0">RANK</th>
                        <th scope="col border-bottom-0">USER NAME</th>
                        <th scope="col border-bottom-0">JOINED</th>
                    </tr>
                </thead>
                <tbody>
                   
                    @foreach ($top_users as $key => $data)
                        <tr>
                            <td>{{ $key + 1 }}</td> <!-- Increment rank with each row -->
                            <td>{{ $data->name }}</td>
                            <td>{{ $data->total_refer }} <small>user</small></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.countdown/2.2.0/jquery.countdown.min.js" integrity="sha512-lteuRD+aUENrZPTXWFRPTBcDDxIGWe5uu0apPEn+3ZKYDwDaEErIK9rvR0QzUGmUQ55KFE2RqGTVoZsKctGMVw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    // Function to refresh the page after one month (30 days)
    function refreshPageAfterOneMonth() {
        var lastRefreshTimestamp = localStorage.getItem('lastRefreshTimestamp');
        var oneMonthInMilliseconds = 30 * 24 * 60 * 60 * 1000; // 30 days * 24 hours * 60 minutes * 60 seconds * 1000 milliseconds
        var currentTimestamp = new Date().getTime();

        if (!lastRefreshTimestamp || currentTimestamp - lastRefreshTimestamp >= oneMonthInMilliseconds) {
            // If it's been more than one month or the timestamp doesn't exist, refresh the page
            location.reload();
            localStorage.setItem('lastRefreshTimestamp', currentTimestamp);
        }
    }

    // Call the function when the page loads
    window.addEventListener('load', refreshPageAfterOneMonth);
</script>
@endsection
